Imports System

'
' This class determines if a particular date is a according to a
' collection of Holiday objects.
'
Public Class CompositeHoliday
    Implements IHolidaySet

    Private holidayArray() As IHolidaySet

    ' Constructor
    ' h - An array of IHolidaySet objects
    Public Sub New(ByVal h() As IHolidaySet)
        holidayArray = New IHolidaySet(h.Length) {}
        System.Array.Copy(h, 0, holidayArray, 0, h.Length)
    End Sub

    '
    ' This method returns a array of strings that describe the holidays
    ' that fall on the given date.  If no holidays fall on the given
    ' date, then this method returns an array of length zero.
    '
    ' dt - The date to check
    Public Function Holidays(ByVal dt As DateTime) As String() _
     Implements IHolidaySet.Holidays
        Return holidays0(dt, 0, 0)
    End Function

    Private Function holidays0(ByVal dt As DateTime, ByVal offset As Integer, ByVal ndx As Integer) As String()
        If ndx >= holidayArray.Length Then
            Return New String(offset) {}
        End If
        Dim holidays As String() = holidayArray(ndx).Holidays(dt)
        Dim result As String() = holidays0(dt, offset + holidays.Length, ndx + 1)
        System.Array.Copy(holidays, 0, result, offset, holidays.Length)
        Return result
    End Function
End Class 'CompositeHoliday